/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings.sql;

import de.iani.settings.sql.SQLRunnable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class SQLConnection {
    private String connectURL;
    private Connection connection;
    private String user;
    private String password;
    private String database;
    private int maxTries;
    private HashMap<Object, PreparedStatement> cachedStatements;

    public SQLConnection(String connectURL, String database, String user, String password) throws SQLException {
        this(connectURL, database, user, password, null);
    }

    public SQLConnection(String connectURL, String database, String user, String password, String driverClass) throws SQLException {
        if (driverClass != null) {
            try {
                Class.forName(driverClass);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        this.connectURL = connectURL;
        this.user = user;
        this.password = password;
        this.database = database;
        this.cachedStatements = new HashMap();
        this.maxTries = 3;
        this.connect();
    }

    public synchronized void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
        this.cachedStatements.clear();
    }

    private synchronized void connect() throws SQLException {
        this.disconnect();
        this.connection = this.user != null ? DriverManager.getConnection(this.connectURL, this.user, this.password) : DriverManager.getConnection(this.connectURL);
        this.connection.setAutoCommit(false);
    }

    public synchronized <T> T runCommands(SQLRunnable<T> runnable) throws SQLException {
        int fails = 0;
        while (true) {
            try {
                if (this.connection == null) {
                    this.connect();
                }
                T rv = runnable.execute(this.connection, this);
                this.connection.commit();
                return rv;
            }
            catch (SQLException e) {
                ++fails;
                if (this.connection == null) continue;
                try {
                    if (!this.connection.isClosed()) {
                        this.connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
                if (fails < this.maxTries) continue;
                throw e;
            }
            break;
        }
    }

    public PreparedStatement getOrCreateStatement(String statement) throws SQLException {
        PreparedStatement smt = this.cachedStatements.get(statement);
        if (smt == null || smt.isClosed()) {
            smt = this.connection.prepareStatement(statement);
            this.cachedStatements.put(statement, smt);
        }
        return smt;
    }

    public PreparedStatement getOrCreateStatement(String statement, int autoGeneratedKeys) throws SQLException {
        PreparedStatement smt = this.cachedStatements.get(statement);
        if (smt == null || smt.isClosed()) {
            smt = this.connection.prepareStatement(statement, autoGeneratedKeys);
            this.cachedStatements.put(statement, smt);
        }
        return smt;
    }

    public boolean hasTable(String table) throws SQLException {
        return this.hasTable(this.database, table);
    }

    public boolean hasTable(final String database, final String table) throws SQLException {
        return this.runCommands(new SQLRunnable<Boolean>(){

            @Override
            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = ? AND table_name = ?");
                smt.setString(1, database);
                smt.setString(2, table);
                ResultSet rs = smt.executeQuery();
                boolean rv = false;
                if (rs.next()) {
                    rv = rs.getInt(1) > 0;
                }
                rs.close();
                return rv;
            }
        });
    }

    public boolean hasColumn(String table, String column) throws SQLException {
        return this.hasColumn(this.database, table, column);
    }

    public boolean hasColumn(final String database, final String table, final String column) throws SQLException {
        return this.runCommands(new SQLRunnable<Boolean>(){

            @Override
            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement("SELECT COUNT(*) FROM information_schema.columns WHERE table_schema = ? AND table_name = ? AND column_name = ?");
                smt.setString(1, database);
                smt.setString(2, table);
                smt.setString(3, column);
                ResultSet rs = smt.executeQuery();
                boolean rv = false;
                if (rs.next()) {
                    rv = rs.getInt(1) > 0;
                }
                rs.close();
                return rv;
            }
        });
    }
}

