/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings;

import de.iani.settings.CubesideSettings;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private CubesideSettings plugin;
    private HashMap<UUID, Long> lastWorldChanges;

    public PlayerListener(CubesideSettings plugin) {
        this.plugin = plugin;
        this.lastWorldChanges = new HashMap();
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        ItemStack compass = event.getItemDrop().getItemStack();
        if (compass != null && compass.isSimilar(this.plugin.getSettingsItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        this.plugin.loadPlayerSettings(player);
        this.plugin.checkForSettingsItem(player);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                PlayerListener.this.plugin.checkForSettingsItem(player);
            }
        }, 5L);
        this.lastWorldChanges.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.removeLoadedPlayerSettings(player);
        this.lastWorldChanges.remove(player.getUniqueId());
    }

    @EventHandler
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        final Player player = event.getPlayer();
        this.plugin.checkForSettingsItem(player);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                PlayerListener.this.plugin.checkForSettingsItem(player);
            }
        }, 5L);
        this.lastWorldChanges.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        Player p;
        ItemStack itemInHand;
        if ((event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) && (itemInHand = (p = event.getPlayer()).getInventory().getItemInHand()) != null && itemInHand.isSimilar(this.plugin.getSettingsItem())) {
            event.setCancelled(true);
            Long lastWorldChange = this.lastWorldChanges.get(p.getUniqueId());
            if (lastWorldChange == null || System.currentTimeMillis() - lastWorldChange > 2000L) {
                this.plugin.openSettingsInventoryOnPlayer(p);
            }
        }
    }

    @EventHandler
    public void onClickOnItem(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            ItemStack swap;
            int slot;
            Player p = (Player)event.getWhoClicked();
            ItemStack currentItem = event.getCurrentItem();
            if (currentItem != null && currentItem.isSimilar(this.plugin.getSettingsItem())) {
                event.setCancelled(true);
                return;
            }
            if (event.getAction() == InventoryAction.HOTBAR_SWAP && (slot = event.getHotbarButton()) >= 0 && slot < 9 && (swap = p.getInventory().getItem(slot)) != null && swap.isSimilar(this.plugin.getSettingsItem())) {
                event.setCancelled(true);
                return;
            }
            if (event.getInventory().getName().equals(this.plugin.getSettingsInventoryTitle())) {
                event.setCancelled(true);
                if (event.getSlot() == event.getRawSlot()) {
                    this.plugin.handleSettingsInventoryClick(event.getClickedInventory(), p, event.getRawSlot());
                }
            }
            if (event.getInventory().getName().equals(this.plugin.getSettingsChatInventoryTitle())) {
                event.setCancelled(true);
                if (event.getSlot() == event.getRawSlot()) {
                    this.plugin.handleSettingsChatInventoryClick(event.getClickedInventory(), p, event.getRawSlot());
                }
            }
            if (event.getInventory().getName().equals(this.plugin.getSettingsSoundsInventoryTitle())) {
                event.setCancelled(true);
                if (event.getSlot() == event.getRawSlot()) {
                    this.plugin.handleSettingsSoundsInventoryClick(event.getClickedInventory(), p, event.getRawSlot());
                }
            }
        }
    }
}

