/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings.libs.de.iani.cubesideutils.items;

import de.iani.settings.libs.de.iani.cubesideutils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class EnchantmentNames {
    private static final HashMap<Enchantment, String> enchantmentToName = new HashMap();

    private EnchantmentNames() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    private static void addEnchantment(Enchantment enchantment, String name) {
        enchantmentToName.put(enchantment, name);
    }

    public static String getName(Enchantment enchantment) {
        if (enchantment == null) {
            return null;
        }
        String name = enchantmentToName.get(enchantment);
        if (name != null) {
            return name;
        }
        return StringUtil.capitalizeFirstLetter(enchantment.getKey().getKey(), true);
    }

    public static Enchantment getByName(String name) {
        name = name.toLowerCase();
        Enchantment result = null;
        try {
            result = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        name = StringUtil.SPACES_AND_UNDERSCORES_PATTERN.matcher(name).replaceAll("");
        for (Map.Entry<Enchantment, String> pair : enchantmentToName.entrySet()) {
            String simpleName = StringUtil.BungeeStatics.COLOR_CODES_PATTERN.matcher(pair.getValue()).replaceAll("");
            if (!(simpleName = StringUtil.SPACES_AND_UNDERSCORES_PATTERN.matcher(simpleName).replaceAll("")).equalsIgnoreCase(name)) continue;
            return pair.getKey();
        }
        return null;
    }

    static {
        EnchantmentNames.addEnchantment(Enchantment.ARROW_DAMAGE, "Power");
        EnchantmentNames.addEnchantment(Enchantment.ARROW_FIRE, "Flame");
        EnchantmentNames.addEnchantment(Enchantment.ARROW_INFINITE, "Infinity");
        EnchantmentNames.addEnchantment(Enchantment.ARROW_KNOCKBACK, "Punch");
        EnchantmentNames.addEnchantment(Enchantment.BINDING_CURSE, ChatColor.RED + "Curse of Binding");
        EnchantmentNames.addEnchantment(Enchantment.DAMAGE_ALL, "Sharpness");
        EnchantmentNames.addEnchantment(Enchantment.DAMAGE_ARTHROPODS, "Bane of Anthropods");
        EnchantmentNames.addEnchantment(Enchantment.DAMAGE_UNDEAD, "Smite");
        EnchantmentNames.addEnchantment(Enchantment.DIG_SPEED, "Efficiency");
        EnchantmentNames.addEnchantment(Enchantment.DURABILITY, "Unbreaking");
        EnchantmentNames.addEnchantment(Enchantment.LOOT_BONUS_BLOCKS, "Fortune");
        EnchantmentNames.addEnchantment(Enchantment.LOOT_BONUS_MOBS, "Looting");
        EnchantmentNames.addEnchantment(Enchantment.LUCK, "Luck of the Sea");
        EnchantmentNames.addEnchantment(Enchantment.OXYGEN, "Respiration");
        EnchantmentNames.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, "Protection");
        EnchantmentNames.addEnchantment(Enchantment.PROTECTION_EXPLOSIONS, "Blast Protection");
        EnchantmentNames.addEnchantment(Enchantment.PROTECTION_FALL, "Feather Falling");
        EnchantmentNames.addEnchantment(Enchantment.PROTECTION_FIRE, "Fire Protection");
        EnchantmentNames.addEnchantment(Enchantment.PROTECTION_PROJECTILE, "Projectile Protection");
        EnchantmentNames.addEnchantment(Enchantment.VANISHING_CURSE, ChatColor.RED + "Curse of Vanishing");
        EnchantmentNames.addEnchantment(Enchantment.WATER_WORKER, "Aqua Affinity");
        EnchantmentNames.addEnchantment(Enchantment.LOYALTY, "Loyalty");
        EnchantmentNames.addEnchantment(Enchantment.IMPALING, "Impaling");
        EnchantmentNames.addEnchantment(Enchantment.RIPTIDE, "Riptide");
        EnchantmentNames.addEnchantment(Enchantment.CHANNELING, "Channeling");
    }
}

