/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientBungee;
import de.cubeside.connection.PlayerPropertiesAPI;
import de.cubeside.connection.PlayerPropertiesImplementation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.logging.Level;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class GlobalClientPlugin
extends Plugin {
    private GlobalClientBungee globalClient;
    private PlayerPropertiesImplementation propertiesAPI;

    public void onEnable() {
        this.saveDefaultConfig();
        this.globalClient = new GlobalClientBungee(this);
        this.reconnectClient();
        this.propertiesAPI = new PlayerPropertiesImplementation(this);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ReloadCommand());
    }

    private void saveDefaultConfig() {
        File file;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
            try (InputStream in = this.getResourceAsStream("config.yml");){
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onDisable() {
        if (this.globalClient != null) {
            this.globalClient.shutdown();
        }
        this.globalClient = null;
    }

    public void reconnectClient() {
        try {
            Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "config.yml"));
            String account = configuration.getString("client.account");
            String password = configuration.getString("client.password");
            String host = configuration.getString("server.host");
            int port = configuration.getInt("server.port");
            this.globalClient.setServer(host, port, account, password);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Exception while loading the config", e);
        }
    }

    public ConnectionAPI getConnectionAPI() {
        return this.globalClient;
    }

    public PlayerPropertiesAPI getPropertiesAPI() {
        return this.propertiesAPI;
    }

    public class ReloadCommand
    extends Command {
        public ReloadCommand() {
            super("bungeeglobalclientreload", "globalclient.reload", new String[0]);
        }

        public void execute(CommandSender sender, String[] args) {
            if (!sender.hasPermission("globalclient.reload")) {
                return;
            }
            GlobalClientPlugin.this.reconnectClient();
        }
    }
}

