/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.cache.MethodCounter;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.scripting.MetaData;
import com.griefcraft.sql.Database;
import com.griefcraft.util.TimeUtil;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;

public class Statistics {
    private static int queries = 0;
    private static long startTime = 0L;
    private static long entityCacheHit;
    private static long entityCacheHitNull;
    private static long entityCacheMiss;
    private static long entityCacheMissNull;
    private static long blockCacheHit;
    private static long blockCacheHitNull;
    private static long blockCacheMiss;
    private static long blockCacheMissNull;

    public static void addQuery() {
        ++queries;
    }

    public static double getAverage(long value) {
        return (double)value / (double)Statistics.getTimeRunningSeconds();
    }

    public static int getEntityCount(Class<? extends Entity> clazz) {
        int count = 0;
        for (World world : Bukkit.getServer().getWorlds()) {
            if (clazz == null) {
                count += world.getEntities().size();
                continue;
            }
            for (Entity entity : world.getEntities()) {
                if (entity == null || !clazz.isInstance(entity)) continue;
                ++count;
            }
        }
        return count;
    }

    public static void sendReport(CommandSender sender) {
        LWC lwc = LWC.getInstance();
        sender.sendMessage(" ");
        sender.sendMessage("\u00a74LWC Report");
        sender.sendMessage("  Version: \u00a72" + LWCInfo.FULL_VERSION);
        sender.sendMessage("  Running time: \u00a72" + TimeUtil.timeToString(Statistics.getTimeRunningSeconds()));
        sender.sendMessage("  Players: \u00a72" + Bukkit.getServer().getOnlinePlayers().size() + "/" + Bukkit.getServer().getMaxPlayers());
        sender.sendMessage("  Item entities: \u00a72" + Statistics.getEntityCount(Item.class) + "/" + Statistics.getEntityCount(null));
        sender.sendMessage("  Permissions API: \u00a72" + lwc.getPermissions().getClass().getSimpleName());
        sender.sendMessage("  Currency API: \u00a72" + lwc.getCurrency().getClass().getSimpleName());
        sender.sendMessage(" ");
        sender.sendMessage("\u00a74 ==== Modules ====");
        for (Map.Entry<Plugin, List<MetaData>> entry : lwc.getModuleLoader().getRegisteredModules().entrySet()) {
            Plugin plugin = entry.getKey();
            List<MetaData> modules = entry.getValue();
            if (plugin == null) continue;
            sender.sendMessage("  \u00a72" + plugin.getDescription().getName() + " v" + plugin.getDescription().getVersion() + "\u00a7e -> \u00a72" + modules.size() + "\u00a7e registered modules");
        }
        sender.sendMessage(" ");
        sender.sendMessage("\u00a74 ==== Database ====");
        sender.sendMessage("  Engine: \u00a72" + Database.DefaultType);
        sender.sendMessage("  Protections: \u00a72" + Statistics.formatNumber(lwc.getPhysicalDatabase().getProtectionCount()));
        sender.sendMessage("  Queries: \u00a72" + Statistics.formatNumber(queries) + " | " + String.format("%.2f", Statistics.getAverage(queries)) + " / second");
        sender.sendMessage(" ");
        sender.sendMessage("\u00a74 ==== Cache ==== ");
        ProtectionCache cache = lwc.getProtectionCache();
        double cachePercentFilled = (double)cache.size() / (double)cache.totalCapacity() * 100.0;
        String cacheColour = "\u00a72";
        if (cachePercentFilled > 75.0 && cachePercentFilled < 85.0) {
            cacheColour = "\u00a7e";
        } else if (cachePercentFilled > 85.0 && cachePercentFilled < 95.0) {
            cacheColour = "\u00a7c";
        } else if (cachePercentFilled > 95.0) {
            cacheColour = "\u00a74";
        }
        sender.sendMessage("  Usage: " + cacheColour + String.format("%.2f", cachePercentFilled) + "% \u00a7f ( " + cache.size() + "/" + cache.totalCapacity() + " [" + cache.capacity() + "+" + cache.adaptiveCapacity() + "] )");
        sender.sendMessage("  Blocks: \u00a72Hit: " + Statistics.formatNumber(blockCacheHit) + " + " + Statistics.formatNumber(blockCacheHitNull) + " \u00a74Miss: " + Statistics.formatNumber(blockCacheMiss) + " + " + Statistics.formatNumber(blockCacheMissNull));
        sender.sendMessage("  Entities: \u00a72Hit: " + Statistics.formatNumber(entityCacheHit) + " + " + Statistics.formatNumber(entityCacheHitNull) + " \u00a74Miss: " + Statistics.formatNumber(entityCacheMiss) + " + " + Statistics.formatNumber(entityCacheMissNull));
        sender.sendMessage("  Profile: ");
        Statistics.sendMethodCounter(sender, cache.getMethodCounter());
    }

    private static void sendMethodCounter(CommandSender sender, MethodCounter counter) {
        Map<String, Integer> sorted = counter.sortByValue();
        for (Map.Entry<String, Integer> entry : sorted.entrySet()) {
            String method = entry.getKey();
            int count = entry.getValue();
            sender.sendMessage("    " + method + ": " + Statistics.formatNumber(count) + " (" + String.format("%.2f", Statistics.getAverage(count)) + " / second)");
        }
    }

    public static String formatNumber(long number) {
        return NumberFormat.getInstance().format(number);
    }

    public static int getTimeRunningSeconds() {
        return (int)((System.currentTimeMillis() - startTime) / 1000L);
    }

    public static void init() {
        startTime = System.currentTimeMillis();
    }

    public static void addEntityCacheHit() {
        ++entityCacheHit;
    }

    public static void addEntityCacheHitNull() {
        ++entityCacheHitNull;
    }

    public static void addEntityCacheMiss() {
        ++entityCacheMiss;
    }

    public static void addEntityCacheMissNull() {
        ++entityCacheMissNull;
    }

    public static long getEntityCacheHit() {
        return entityCacheHit;
    }

    public static long getEntityCacheHitNull() {
        return entityCacheHitNull;
    }

    public static long getEntityCacheMiss() {
        return entityCacheMiss;
    }

    public static long getEntityCacheMissNull() {
        return entityCacheMissNull;
    }

    public static void addBlockCacheHit() {
        ++blockCacheHit;
    }

    public static void addBlockCacheHitNull() {
        ++blockCacheHitNull;
    }

    public static void addBlockCacheMiss() {
        ++blockCacheMiss;
    }

    public static void addBlockCacheMissNull() {
        ++blockCacheMissNull;
    }

    public static long getBlockCacheHit() {
        return blockCacheHit;
    }

    public static long getBlockCacheHitNull() {
        return blockCacheHitNull;
    }

    public static long getBlockCacheMiss() {
        return blockCacheMiss;
    }

    public static long getBlockCacheMissNull() {
        return blockCacheMissNull;
    }
}

