/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.setup;

import com.griefcraft.lwc.LWC;
import com.griefcraft.migration.DatabaseMigrator;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.PhysDB;
import org.bukkit.command.CommandSender;

public class DatabaseSetupModule
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        Database.Type databaseType;
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("s", "setup")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("database")) {
            return;
        }
        event.setCancelled(true);
        if (args.length < 2) {
            lwc.sendSimpleUsage(sender, "/lwc setup database <DatabaseType> [args]");
            return;
        }
        Database.DefaultType = databaseType = Database.Type.matchType(args[1]);
        if (databaseType == null) {
            lwc.sendLocale(sender, "lwc.setup.database.invalid", new Object[0]);
            return;
        }
        DatabaseMigrator migrator = new DatabaseMigrator();
        PhysDB fromDatabase = lwc.getPhysicalDatabase();
        lwc.reloadDatabase();
        if (!migrator.migrate(fromDatabase, lwc.getPhysicalDatabase())) {
            lwc.sendLocale(sender, "lwc.setup.database.failure", "type", databaseType.toString());
            return;
        }
        lwc.sendLocale(sender, "lwc.setup.database.success", "type", databaseType.toString());
        lwc.getConfiguration().setProperty("database.adapter", databaseType.toString().toLowerCase());
        lwc.getConfiguration().save();
        lwc.reloadDatabase();
    }
}

