/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.limits;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.util.config.Configuration;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class LimitsModule
extends JavaModule {
    public static final String PERMISSION_NODE_GLOBAL = "lwc.limit.";
    public static final String PERMISSION_NODE_BLOCK = "lwc.limit.block.";
    private Configuration configuration = Configuration.load("limits.yml", false);
    private int UNLIMITED = Integer.MAX_VALUE;
    private boolean enabled = LWC.getInstance().getConfiguration().getBoolean("optional.useProtectionLimits", true);

    public void set(String path, Object value) {
        this.configuration.setProperty(path, value);
    }

    public boolean save() {
        return this.configuration.save();
    }

    public boolean hasReachedLimit(Player player, Block block) {
        if (this.configuration == null) {
            return false;
        }
        LWC lwc = LWC.getInstance();
        int limit = this.mapProtectionLimit(player, block.getType());
        if (limit == this.UNLIMITED) {
            return false;
        }
        Type type = Type.resolve(this.resolveString(player, "type"));
        return (switch (type) {
            case Type.CUSTOM -> lwc.getPhysicalDatabase().getProtectionCount(player.getName(), block.getType());
            case Type.DEFAULT -> lwc.getPhysicalDatabase().getProtectionCount(player.getName());
            default -> throw new UnsupportedOperationException("Limit type " + type.toString() + " is undefined in LimitsModule::hasReachedLimit");
        }) >= limit;
    }

    public PermissionAttachmentInfo searchPermissions(Player player, String prefix) {
        for (PermissionAttachmentInfo attachment : player.getEffectivePermissions()) {
            String permission = attachment.getPermission();
            if (!attachment.getValue() || !permission.startsWith(prefix)) continue;
            return attachment;
        }
        return null;
    }

    public int searchPermissionsForInteger(Player player, String prefix) {
        PermissionAttachmentInfo attachment = this.searchPermissions(player, prefix);
        if (attachment == null) {
            return -1;
        }
        return Integer.parseInt(attachment.getPermission().substring(prefix.length()));
    }

    public int mapProtectionLimit(Player player, Material block) {
        if (this.configuration == null) {
            return 0;
        }
        int limit = -1;
        Type type = Type.resolve(this.resolveString(player, "type"));
        int globalLimit = this.searchPermissionsForInteger(player, PERMISSION_NODE_GLOBAL);
        if (globalLimit >= 0) {
            return globalLimit;
        }
        int blockLimit = this.searchPermissionsForInteger(player, PERMISSION_NODE_BLOCK + block.name() + ".");
        if (blockLimit != -1) {
            return blockLimit;
        }
        switch (type) {
            case DEFAULT: {
                limit = this.resolveInteger(player, "limit");
                break;
            }
            case CUSTOM: {
                if (limit == -1) {
                    String name = StringUtils.replace((String)block.name().toLowerCase(), (String)"block", (String)"");
                    if (name.endsWith("_")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    limit = this.resolveInteger(player, name);
                }
                if (limit != -1) break;
                limit = this.resolveInteger(player, "limit");
                break;
            }
        }
        return limit == -1 ? this.UNLIMITED : limit;
    }

    private String resolveString(Player player, String node) {
        LWC lwc = LWC.getInstance();
        String value = this.configuration.getString("players." + player.getName() + "." + node);
        if (value == null) {
            for (String groupName : lwc.getPermissions().getGroups(player)) {
                if (groupName == null || groupName.isEmpty() || value != null) continue;
                value = this.map("groups." + groupName + "." + node);
            }
        }
        if (value == null) {
            value = this.map("master." + node);
        }
        return value != null && !value.isEmpty() ? value : null;
    }

    private int resolveInteger(Player player, String node) {
        LWC lwc = LWC.getInstance();
        int value = -1;
        String temp = this.configuration.getString("players." + player.getName() + "." + node);
        if (temp != null && !temp.isEmpty()) {
            value = this.parseInt(temp);
        }
        if (value == -1) {
            for (String groupName : lwc.getPermissions().getGroups(player)) {
                int resolved;
                if (groupName == null || groupName.isEmpty() || (temp = this.map("groups." + groupName + "." + node)) == null || temp.isEmpty() || (resolved = this.parseInt(temp)) <= value) continue;
                value = resolved;
            }
        }
        if (value == -1 && (temp = this.map("master." + node)) != null && !temp.isEmpty()) {
            value = this.parseInt(temp);
        }
        return value;
    }

    private int parseInt(String input) {
        if (input.equalsIgnoreCase("unlimited")) {
            return this.UNLIMITED;
        }
        return Integer.parseInt(input);
    }

    private String map(String path) {
        String value = this.configuration.getString(path);
        if (value == null) {
            int lastIndex = path.lastIndexOf(".");
            String node = path.substring(lastIndex + 1);
            value = this.configuration.getString("master." + node);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        Block block;
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        LWC lwc = event.getLWC();
        Player player = event.getPlayer();
        if (this.hasReachedLimit(player, block = event.getBlock())) {
            lwc.sendLocale((CommandSender)player, "protection.exceeded", new Object[0]);
            event.setCancelled(true);
        }
    }

    public static enum Type {
        NULL,
        DEFAULT,
        CUSTOM;


        public static Type resolve(String name) {
            for (Type type : Type.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                return type;
            }
            return NULL;
        }
    }
}

