/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.scripting;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.scripting.MetaData;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleException;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCEvent;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.scripting.event.LWCProtectionRemovePostEvent;
import com.griefcraft.scripting.event.LWCRedstoneEvent;
import com.griefcraft.scripting.event.LWCReloadEvent;
import com.griefcraft.scripting.event.LWCSendLocaleEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class ModuleLoader {
    private LWC lwc;
    public static final String ROOT_PATH = "plugins/LWC/";
    private final Map<Plugin, List<MetaData>> pluginModules = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Event, List<Module>> fastModuleCache = new HashMap<Event, List<Module>>();
    private final Map<String, Boolean> overrideCache = new HashMap<String, Boolean>();

    public ModuleLoader(LWC lwc) {
        this.lwc = lwc;
        this.populateFastModuleCache();
    }

    private void populateFastModuleCache() {
        for (Event event : Event.values()) {
            this.fastModuleCache.put(event, new ArrayList(10));
        }
    }

    private void registerFastCache(Module module) {
        Method[] methods;
        Class<Object> superclass = module.getClass().getSuperclass();
        if (superclass == null) {
            throw new IllegalArgumentException("Method cannot be its own superclass (?)");
        }
        if (superclass == Object.class) {
            superclass = Module.class;
        }
        for (Method method : methods = superclass.getDeclaredMethods()) {
            Class<?>[] parameters;
            boolean doesOverride = this.doesObjectOverrideMethod(module, method);
            if (!doesOverride || (parameters = method.getParameterTypes()).length != 1) continue;
            Event event = null;
            Class<?> parameter = parameters[0];
            if (parameter == LWCAccessEvent.class) {
                event = Event.ACCESS_REQUEST;
            } else if (parameter == LWCBlockInteractEvent.class) {
                event = Event.INTERACT_BLOCK;
            } else if (parameter == LWCCommandEvent.class) {
                event = Event.COMMAND;
            } else if (parameter == LWCDropItemEvent.class) {
                event = Event.DROP_ITEM;
            } else if (parameter == LWCProtectionDestroyEvent.class) {
                event = Event.DESTROY_PROTECTION;
            } else if (parameter == LWCProtectionInteractEvent.class) {
                event = Event.INTERACT_PROTECTION;
            } else if (parameter == LWCProtectionRegisterEvent.class) {
                event = Event.REGISTER_PROTECTION;
            } else if (parameter == LWCProtectionRemovePostEvent.class) {
                event = Event.POST_REMOVAL;
            } else if (parameter == LWCProtectionRegistrationPostEvent.class) {
                event = Event.POST_REGISTRATION;
            } else if (parameter == LWCSendLocaleEvent.class) {
                event = Event.SEND_LOCALE;
            } else if (parameter == LWCRedstoneEvent.class) {
                event = Event.REDSTONE;
            } else if (parameter == LWCReloadEvent.class) {
                event = Event.RELOAD_EVENT;
            }
            if (event == null) continue;
            List<Module> modules = this.fastModuleCache.get((Object)event);
            modules.add(module);
        }
    }

    public boolean doesObjectOverrideMethod(Object object, Method method) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        String methodName = method.getName();
        String cacheKey = object.getClass().getSimpleName() + methodName;
        if (this.overrideCache.containsKey(cacheKey)) {
            return this.overrideCache.get(cacheKey);
        }
        boolean result = false;
        for (Method declaredMethod : object.getClass().getDeclaredMethods()) {
            if (!declaredMethod.getName().equals(methodName)) continue;
            result = true;
            break;
        }
        this.overrideCache.put(cacheKey, result);
        return result;
    }

    public void dispatchEvent(LWCEvent event) {
        if (event == null) {
            return;
        }
        try {
            List<Module> modules = this.fastModuleCache.get((Object)event.getEventType());
            Event type = event.getEventType();
            for (Module module : modules) {
                if (type == Event.INTERACT_PROTECTION) {
                    module.onProtectionInteract((LWCProtectionInteractEvent)event);
                    continue;
                }
                if (type == Event.INTERACT_BLOCK) {
                    module.onBlockInteract((LWCBlockInteractEvent)event);
                    continue;
                }
                if (type == Event.SEND_LOCALE) {
                    module.onSendLocale((LWCSendLocaleEvent)event);
                    continue;
                }
                if (type == Event.ACCESS_REQUEST) {
                    module.onAccessRequest((LWCAccessEvent)event);
                    continue;
                }
                if (type == Event.COMMAND) {
                    module.onCommand((LWCCommandEvent)event);
                    continue;
                }
                if (type == Event.DROP_ITEM) {
                    module.onDropItem((LWCDropItemEvent)event);
                    continue;
                }
                if (type == Event.DESTROY_PROTECTION) {
                    module.onDestroyProtection((LWCProtectionDestroyEvent)event);
                    continue;
                }
                if (type == Event.REGISTER_PROTECTION) {
                    module.onRegisterProtection((LWCProtectionRegisterEvent)event);
                    continue;
                }
                if (type == Event.POST_REMOVAL) {
                    module.onPostRemoval((LWCProtectionRemovePostEvent)event);
                    continue;
                }
                if (type == Event.POST_REGISTRATION) {
                    module.onPostRegistration((LWCProtectionRegistrationPostEvent)event);
                    continue;
                }
                if (type == Event.REDSTONE) {
                    module.onRedstone((LWCRedstoneEvent)event);
                    continue;
                }
                if (type != Event.RELOAD_EVENT) continue;
                module.onReload((LWCReloadEvent)event);
            }
        }
        catch (Throwable throwable) {
            throw new ModuleException("LWC Module threw an uncaught exception! LWC version: " + LWCInfo.FULL_VERSION, throwable);
        }
    }

    public void shutdown() {
        this.pluginModules.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() {
        Map<Plugin, List<MetaData>> map = this.pluginModules;
        synchronized (map) {
            LinkedHashMap<LWCPlugin, List<MetaData>> linkedHashMap = new LinkedHashMap<LWCPlugin, List<MetaData>>();
            linkedHashMap.put(this.lwc.getPlugin(), this.pluginModules.get((Object)this.lwc.getPlugin()));
            linkedHashMap.putAll(this.pluginModules);
            this.pluginModules.clear();
            this.pluginModules.putAll(linkedHashMap);
        }
        for (List list : this.pluginModules.values()) {
            for (MetaData metaData : list) {
                if (metaData.isLoaded()) continue;
                metaData.getModule().load(this.lwc);
                metaData.trigger();
            }
        }
    }

    public Module getModule(Class<? extends Module> clazz) {
        for (List<MetaData> modules : this.pluginModules.values()) {
            for (MetaData metaData : modules) {
                Module module = metaData.getModule();
                if (module.getClass() != clazz) continue;
                return module;
            }
        }
        return null;
    }

    public Map<Plugin, List<MetaData>> getRegisteredModules() {
        return Collections.unmodifiableMap(this.pluginModules);
    }

    public int getModuleCount() {
        int count = 0;
        for (List<MetaData> modules : this.pluginModules.values()) {
            count += modules.size();
        }
        return count;
    }

    public void registerModule(Plugin plugin, Module module) {
        List<MetaData> modules = null;
        if (plugin != null) {
            modules = this.pluginModules.get(plugin);
        }
        if (modules == null) {
            modules = new ArrayList<MetaData>();
        }
        MetaData metaData = new MetaData(module);
        modules.add(metaData);
        this.pluginModules.put(plugin, modules);
        this.registerFastCache(module);
    }

    public void removeModules(Plugin plugin) {
        this.pluginModules.remove(plugin);
    }

    public static enum Event {
        LOAD(0),
        UNLOAD(0),
        COMMAND(3),
        REDSTONE(3),
        DESTROY_PROTECTION(5),
        INTERACT_PROTECTION(5),
        INTERACT_BLOCK(3),
        REGISTER_PROTECTION(2),
        ACCESS_PROTECTION(2),
        ADMIN_PROTECTION(2),
        DROP_ITEM(3),
        POST_REGISTRATION(1),
        POST_REMOVAL(1),
        SEND_LOCALE(2),
        ACCESS_REQUEST,
        RELOAD_EVENT;

        int arguments;

        private Event() {
        }

        private Event(int arguments) {
            this.arguments = arguments;
        }

        public int getExpectedArguments() {
            return this.arguments;
        }
    }
}

