/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.setup;

import com.griefcraft.lwc.LWC;
import com.griefcraft.modules.limits.LimitsV2;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.util.config.Configuration;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LimitsSetup
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("s", "setup")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("limits")) {
            return;
        }
        event.setCancelled(true);
        LimitsV2 limits = (LimitsV2)lwc.getModuleLoader().getModule(LimitsV2.class);
        if (args.length == 1) {
            sender.sendMessage("Default limits:");
            limits.sendLimits(sender, null, limits.getDefaultLimits());
        } else {
            String name = args[1];
            boolean isGroup = false;
            if (name.startsWith("g:")) {
                isGroup = true;
                name = name.substring(2);
            }
            if (args.length == 2) {
                if (!isGroup) {
                    List<LimitsV2.Limit> found = limits.getPlayerLimits().get(name.toLowerCase());
                    Player target = lwc.getPlugin().getServer().getPlayer(name);
                    if (found == null) {
                        sender.sendMessage("\u00a74Player override not found.");
                    } else {
                        limits.sendLimits(sender, target, found);
                    }
                } else {
                    List<LimitsV2.Limit> found = limits.getGroupLimits().get(name);
                    if (found == null) {
                        sender.sendMessage("\u00a74Group override not found.");
                    } else {
                        limits.sendLimits(sender, null, found);
                    }
                }
            } else {
                Configuration configuration = limits.getConfiguration();
                boolean modified = false;
                Object path = name.equalsIgnoreCase("default") ? "defaults." : (isGroup ? "groups." + name + "." : "players." + this.getCaseCorrectPlayerName(configuration, name) + ".");
                if (args.length == 3) {
                    Object value;
                    if (args[2].equalsIgnoreCase("unlimited")) {
                        value = "unlimited";
                    } else {
                        try {
                            value = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage("\u00a74Invalid number for \"" + args[2] + "\"");
                            return;
                        }
                    }
                    configuration.setProperty((String)path + "default", value);
                    modified = true;
                } else {
                    for (int index = 2; index < args.length; index += 2) {
                        Object intValue;
                        if (index + 1 > args.length) continue;
                        String key = args[index];
                        String value = args[index + 1];
                        if (value.equalsIgnoreCase("unlimited")) {
                            intValue = value;
                        } else {
                            try {
                                intValue = Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage("\u00a74Invalid number for: \"" + value + "\"!");
                                return;
                            }
                        }
                        if (key.equalsIgnoreCase("default")) {
                            configuration.setProperty((String)path + "default", intValue);
                            modified = true;
                            continue;
                        }
                        Material material = Material.matchMaterial((String)key);
                        if (material == null) {
                            sender.sendMessage("\u00a74Invalid material/block: \"" + value + "\"!");
                            return;
                        }
                        configuration.setProperty((String)path + material.toString().toLowerCase(), intValue);
                        modified = true;
                    }
                }
                if (modified) {
                    configuration.save();
                    limits.reload();
                    sender.sendMessage("\u00a72Set the limits for \"" + name + "\" successfully.");
                }
            }
        }
    }

    private String getCaseCorrectPlayerName(Configuration configuration, String player) {
        try {
            List<String> keys = configuration.getKeys("players");
            for (String key : keys) {
                if (!key.equalsIgnoreCase(player)) continue;
                return key;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return player;
    }
}

