/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.lwc;

import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.cache.CacheKey;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.integration.ICurrency;
import com.griefcraft.integration.IPermissions;
import com.griefcraft.integration.currency.NoCurrency;
import com.griefcraft.integration.currency.VaultCurrency;
import com.griefcraft.integration.permissions.SuperPermsPermissions;
import com.griefcraft.integration.permissions.VaultPermissions;
import com.griefcraft.lwc.BlockMap;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.lwc.MessageParser;
import com.griefcraft.migration.ConfigPost300;
import com.griefcraft.migration.MySQLPost200;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.admin.AdminCache;
import com.griefcraft.modules.admin.AdminCleanup;
import com.griefcraft.modules.admin.AdminClear;
import com.griefcraft.modules.admin.AdminDump;
import com.griefcraft.modules.admin.AdminExpire;
import com.griefcraft.modules.admin.AdminFind;
import com.griefcraft.modules.admin.AdminForceOwner;
import com.griefcraft.modules.admin.AdminLocale;
import com.griefcraft.modules.admin.AdminPurge;
import com.griefcraft.modules.admin.AdminPurgeBanned;
import com.griefcraft.modules.admin.AdminRebuild;
import com.griefcraft.modules.admin.AdminReload;
import com.griefcraft.modules.admin.AdminRemove;
import com.griefcraft.modules.admin.AdminReport;
import com.griefcraft.modules.admin.AdminTransfer;
import com.griefcraft.modules.admin.AdminVersion;
import com.griefcraft.modules.admin.AdminView;
import com.griefcraft.modules.admin.BaseAdminModule;
import com.griefcraft.modules.confirm.ConfirmModule;
import com.griefcraft.modules.create.CreateModule;
import com.griefcraft.modules.credits.CreditsModule;
import com.griefcraft.modules.debug.DebugModule;
import com.griefcraft.modules.destroy.DestroyModule;
import com.griefcraft.modules.doors.DoorsModule;
import com.griefcraft.modules.flag.BaseFlagModule;
import com.griefcraft.modules.free.FreeModule;
import com.griefcraft.modules.history.HistoryModule;
import com.griefcraft.modules.info.InfoModule;
import com.griefcraft.modules.limits.LimitsModule;
import com.griefcraft.modules.limits.LimitsV2;
import com.griefcraft.modules.modes.BaseModeModule;
import com.griefcraft.modules.modes.NoSpamModule;
import com.griefcraft.modules.modes.PersistModule;
import com.griefcraft.modules.modify.ModifyModule;
import com.griefcraft.modules.owners.OwnersModule;
import com.griefcraft.modules.pluginsupport.WorldGuard;
import com.griefcraft.modules.redstone.RedstoneModule;
import com.griefcraft.modules.setup.BaseSetupModule;
import com.griefcraft.modules.setup.DatabaseSetupModule;
import com.griefcraft.modules.setup.LimitsSetup;
import com.griefcraft.modules.unlock.UnlockModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCReloadEvent;
import com.griefcraft.scripting.event.LWCSendLocaleEvent;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.PhysDB;
import com.griefcraft.util.BlockUtil;
import com.griefcraft.util.ProtectionFinder;
import com.griefcraft.util.Statistics;
import com.griefcraft.util.StringUtil;
import com.griefcraft.util.UUIDRegistry;
import com.griefcraft.util.config.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class LWC {
    public static boolean ENABLED = false;
    private static LWC instance;
    private Configuration configuration;
    private final ModuleLoader moduleLoader;
    private final ProtectionCache protectionCache;
    private PhysDB physicalDatabase;
    private LWCPlugin plugin;
    private IPermissions permissions;
    private ICurrency currency;
    private HashSet<EntityType> protectableEntites = new HashSet();
    private HashSet<Material> protectableBlocks = new HashSet();
    private final Map<String, String> protectionConfigurationCache = new HashMap<String, String>();

    public LWC(LWCPlugin plugin) {
        this.plugin = plugin;
        instance = this;
        this.configuration = Configuration.load("core.yml");
        this.protectionCache = new ProtectionCache(this);
        this.moduleLoader = new ModuleLoader(this);
    }

    public static LWC getInstance() {
        return instance;
    }

    public static String materialToString(Material material) {
        if (material != null) {
            String materialName = LWC.normalizeMaterialName(material);
            String locale = LWC.getInstance().getPlugin().getMessageParser().parseMessage(materialName.toLowerCase(), new Object[0]);
            if (locale == null) {
                locale = materialName;
            }
            return StringUtil.capitalizeFirstLetter(StringUtil.fastReplace(locale, '_', ' '));
        }
        return "";
    }

    public static String normalizeMaterialName(Material material) {
        String name = material.toString().toLowerCase();
        if (name.contains("sign")) {
            name = "sign";
        }
        return name.toLowerCase();
    }

    public boolean canAccessProtection(Player player, Block block) {
        Protection protection = this.findProtection(block.getLocation());
        return protection != null && this.canAccessProtection(player, protection);
    }

    public boolean canAccessProtection(Player player, int x, int y, int z) {
        return this.canAccessProtection(player, this.physicalDatabase.loadProtection(player.getWorld().getName(), x, y, z));
    }

    public boolean canAdminProtection(Player player, Block block) {
        Protection protection = this.findProtection(block.getLocation());
        return protection != null && this.canAdminProtection(player, protection);
    }

    public boolean canAdminProtection(Player player, Protection protection) {
        if (protection == null || player == null) {
            return true;
        }
        if (this.isAdmin(player)) {
            return true;
        }
        Permission.Access access = Permission.Access.NONE;
        switch (protection.getType()) {
            case PUBLIC: 
            case PASSWORD: 
            case PRIVATE: 
            case DONATION: 
            case SHOWCASE: {
                if (protection.isOwner(player)) {
                    return true;
                }
                if (protection.getAccess(player.getUniqueId().toString(), Permission.Type.PLAYER) == Permission.Access.ADMIN) {
                    return true;
                }
                if (protection.getAccess(player.getName(), Permission.Type.PLAYER) == Permission.Access.ADMIN) {
                    return true;
                }
                for (String groupName : this.permissions.getGroups(player)) {
                    if (protection.getAccess(groupName, Permission.Type.GROUP) != Permission.Access.ADMIN) continue;
                    return true;
                }
                break;
            }
        }
        LWCAccessEvent event = new LWCAccessEvent(player, protection, access);
        this.moduleLoader.dispatchEvent(event);
        return event.getAccess() == Permission.Access.ADMIN;
    }

    public boolean canDestoryProtection(Player player, Protection protection) {
        if (protection.isOwner(player)) {
            return true;
        }
        return this.canAdminProtection(player, protection) && this.getConfiguration().getBoolean("optional.protectionAdminCanDestroyProtections", false);
    }

    public Block findAdjacentBlock(Block block, Material material, Block ... ignore) {
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        List<Block> ignoreList = Arrays.asList(ignore);
        for (BlockFace face : faces) {
            Block adjacentBlock = block.getRelative(face);
            if (adjacentBlock.getType() != material || ignoreList.contains(adjacentBlock)) continue;
            return adjacentBlock;
        }
        return null;
    }

    public Block findAdjacentBlockOnAllSides(Block block, Material material, Block ... ignore) {
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
        List<Block> ignoreList = Arrays.asList(ignore);
        for (BlockFace face : faces) {
            Block adjacentBlock = block.getRelative(face);
            if (adjacentBlock.getType() != material || ignoreList.contains(adjacentBlock)) continue;
            return adjacentBlock;
        }
        return null;
    }

    public List<Protection> findAdjacentProtectionsOnAllSides(Block block, Block ... ignore) {
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
        List<Block> ignoreList = Arrays.asList(ignore);
        ArrayList<Protection> found = new ArrayList<Protection>();
        for (BlockFace face : faces) {
            Protection protection;
            Block adjacentBlock = block.getRelative(face);
            if (ignoreList.contains(adjacentBlock) || (protection = this.findProtection(adjacentBlock.getLocation())) == null) continue;
            found.add(protection);
        }
        return found;
    }

    public void destruct() {
        this.moduleLoader.shutdown();
        if (this.physicalDatabase != null) {
            this.physicalDatabase.dispose();
        }
        this.physicalDatabase = null;
    }

    public void log(String str) {
        this.plugin.getLogger().info(str);
    }

    public String encrypt(String text) {
        return StringUtil.encrypt(text);
    }

    public boolean enforceAccess(Player player, Protection protection, Block block, boolean hasAccess, boolean showMessage) {
        boolean messageInActionBar;
        MessageParser parser = this.plugin.getMessageParser();
        if (block == null || protection == null) {
            return true;
        }
        if (!(protection.isEntity() || protection.getBlockId() > 0 && block.getType() == protection.getBlockMaterial())) {
            protection.setBlockMaterial(block.getType());
            protection.save();
        }
        if (protection.getWorld() == null || !block.getWorld().getName().equals(protection.getWorld())) {
            protection.setWorld(block.getWorld().getName());
            protection.save();
        }
        boolean bl = messageInActionBar = protection.getType() == Protection.Type.PUBLIC;
        if (hasAccess) {
            long timestamp = System.currentTimeMillis() / 1000L;
            if (protection.isRealOwner(player) || protection.getAccess(player.getUniqueId().toString(), Permission.Type.PLAYER) != Permission.Access.NONE) {
                if (Math.abs(protection.getLastAccessed() - timestamp) > 5L) {
                    protection.setLastAccessed(timestamp);
                    protection.saveLastAccessed();
                }
                messageInActionBar = true;
            }
        }
        boolean permShowNotices = this.hasPermission(player, "lwc.shownotices");
        boolean messageSent = false;
        if (permShowNotices && this.configuration.getBoolean("core.showNotices", true) && !Boolean.parseBoolean(this.resolveProtectionConfiguration(block, "quiet"))) {
            boolean isOwner = protection.isOwner(player);
            boolean showMyNotices = this.configuration.getBoolean("core.showMyNotices", true);
            if (!isOwner || isOwner && (showMyNotices || permShowNotices)) {
                String owner = protection.isRealOwner(player) ? parser.parseMessage("you", new Object[0]) : protection.getOwnerName();
                String blockName = LWC.materialToString(block);
                String protectionTypeToString = parser.parseMessage(protection.typeToString().toLowerCase(), new Object[0]);
                if (protectionTypeToString == null) {
                    protectionTypeToString = "Unknown";
                }
                if (showMessage) {
                    if (parser.parseMessage("protection." + blockName.toLowerCase() + ".notice.protected", new Object[0]) != null) {
                        if (messageInActionBar) {
                            this.sendLocaleToActionBar((CommandSender)player, "protection." + blockName.toLowerCase() + ".notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                        } else {
                            this.sendLocale((CommandSender)player, "protection." + blockName.toLowerCase() + ".notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                        }
                    } else if (messageInActionBar) {
                        this.sendLocaleToActionBar((CommandSender)player, "protection.general.notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                    } else {
                        this.sendLocale((CommandSender)player, "protection.general.notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                    }
                    messageSent = true;
                }
            }
        }
        if (!hasAccess && showMessage) {
            Protection.Type type = protection.getType();
            if (type == Protection.Type.PASSWORD) {
                this.sendLocale((CommandSender)player, "protection.general.locked.password", "block", LWC.materialToString(block), "owner", protection.getOwnerName());
            } else if (!(type != Protection.Type.PRIVATE && type != Protection.Type.DONATION && type != Protection.Type.SHOWCASE || messageSent)) {
                this.sendLocale((CommandSender)player, "protection.general.locked.private", "block", LWC.materialToString(block), "owner", protection.getOwnerName());
            }
        }
        return hasAccess;
    }

    public boolean canAccessProtection(Player player, Protection protection) {
        if (protection == null || player == null) {
            return true;
        }
        if (this.isAdmin(player)) {
            return true;
        }
        if (this.isMod(player)) {
            return true;
        }
        Permission.Access access = Permission.Access.NONE;
        switch (protection.getType()) {
            case PUBLIC: 
            case DONATION: 
            case SHOWCASE: {
                return true;
            }
            case PASSWORD: {
                if (this.wrapPlayer((CommandSender)player).isProtectionAccessible(protection)) {
                    return true;
                }
            }
            case PRIVATE: {
                if (protection.isOwner(player)) {
                    return true;
                }
                if (protection.getAccess(player.getUniqueId().toString(), Permission.Type.PLAYER).ordinal() >= Permission.Access.PLAYER.ordinal()) {
                    return true;
                }
                if (protection.getAccess(player.getName(), Permission.Type.PLAYER).ordinal() >= Permission.Access.PLAYER.ordinal()) {
                    return true;
                }
                for (Permission permission : protection.getPermissions()) {
                    if (permission.getType() != Permission.Type.ITEM || player.getInventory().getItemInMainHand() == null || !player.getInventory().getItemInMainHand().getType().name().equals(permission.getName())) continue;
                    return true;
                }
                for (String groupName : this.permissions.getGroups(player)) {
                    if (protection.getAccess(groupName, Permission.Type.GROUP).ordinal() < Permission.Access.PLAYER.ordinal()) continue;
                    return true;
                }
                break;
            }
        }
        LWCAccessEvent event = new LWCAccessEvent(player, protection, access);
        this.moduleLoader.dispatchEvent(event);
        return event.getAccess() == Permission.Access.PLAYER || event.getAccess() == Permission.Access.ADMIN;
    }

    public boolean canAccessProtectionContents(Player player, Protection protection) {
        if (protection == null || player == null) {
            return true;
        }
        if (this.isAdmin(player)) {
            return true;
        }
        if (this.isMod(player)) {
            return true;
        }
        Permission.Access access = Permission.Access.NONE;
        switch (protection.getType()) {
            case PUBLIC: {
                return true;
            }
            case PASSWORD: {
                if (this.wrapPlayer((CommandSender)player).isProtectionAccessible(protection)) {
                    return true;
                }
            }
            case PRIVATE: 
            case DONATION: 
            case SHOWCASE: {
                if (protection.isOwner(player)) {
                    return true;
                }
                if (protection.getAccess(player.getUniqueId().toString(), Permission.Type.PLAYER).ordinal() >= Permission.Access.PLAYER.ordinal()) {
                    return true;
                }
                if (protection.getAccess(player.getName(), Permission.Type.PLAYER).ordinal() >= Permission.Access.PLAYER.ordinal()) {
                    return true;
                }
                for (Permission permission : protection.getPermissions()) {
                    if (permission.getType() != Permission.Type.ITEM || player.getInventory().getItemInMainHand() == null || !player.getInventory().getItemInMainHand().getType().name().equals(permission.getName())) continue;
                    return true;
                }
                for (String groupName : this.permissions.getGroups(player)) {
                    if (protection.getAccess(groupName, Permission.Type.GROUP).ordinal() < Permission.Access.PLAYER.ordinal()) continue;
                    return true;
                }
                break;
            }
        }
        LWCAccessEvent event = new LWCAccessEvent(player, protection, access);
        this.moduleLoader.dispatchEvent(event);
        return event.getAccess() == Permission.Access.PLAYER || event.getAccess() == Permission.Access.ADMIN;
    }

    public boolean isMod(Player player) {
        return this.hasPermission(player, "lwc.mod");
    }

    public boolean isAdmin(Player player) {
        if (player.isOp() && this.configuration.getBoolean("core.opIsLWCAdmin", true)) {
            return true;
        }
        return this.hasPermission(player, "lwc.admin");
    }

    public boolean hasPermission(Player player, String node) {
        try {
            return player.hasPermission(node);
        }
        catch (NoSuchMethodError e) {
            return !node.contains("admin") && !node.contains("mod");
        }
    }

    public LWCPlayer wrapPlayer(CommandSender sender) {
        if (sender instanceof LWCPlayer) {
            return (LWCPlayer)sender;
        }
        if (!(sender instanceof Player)) {
            return null;
        }
        return LWCPlayer.getPlayer((Player)sender);
    }

    public Player findPlayer(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            Location location = player.getLocation();
            int plrX = location.getBlockX();
            int plrY = location.getBlockY();
            int plrZ = location.getBlockZ();
            if (location.getWorld() != world || plrX < minX || plrX > maxX || plrY < plrY || plrY > maxY || plrZ < minZ || plrZ > maxZ) continue;
            return player;
        }
        return null;
    }

    public void sendLocaleToActionBar(CommandSender sender, String key, Object ... args) {
        MessageParser parser = this.plugin.getMessageParser();
        String parsed = parser.parseMessage(key, args);
        if (parsed == null) {
            return;
        }
        String[] message = StringUtils.split((String)parsed, (char)'\n');
        if (sender instanceof Player) {
            LWCSendLocaleEvent evt = new LWCSendLocaleEvent((Player)sender, key);
            this.moduleLoader.dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
        }
        if (message == null) {
            sender.sendMessage("\u00a74LWC: \u00a7fUndefined locale: \"\u00a78" + key + "\u00a7f\"");
            return;
        }
        if (message.length > 0 && message[0].equalsIgnoreCase("null")) {
            return;
        }
        boolean firstLine = true;
        for (String line : message) {
            if (firstLine && sender instanceof Player) {
                ((Player)sender).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)line));
            } else {
                sender.sendMessage(line);
            }
            firstLine = false;
        }
    }

    public void sendLocale(CommandSender sender, String key, Object ... args) {
        MessageParser parser = this.plugin.getMessageParser();
        String parsed = parser.parseMessage(key, args);
        if (parsed == null) {
            return;
        }
        String[] message = StringUtils.split((String)parsed, (char)'\n');
        if (sender instanceof Player) {
            LWCSendLocaleEvent evt = new LWCSendLocaleEvent((Player)sender, key);
            this.moduleLoader.dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
        }
        if (message == null) {
            sender.sendMessage("\u00a74LWC: \u00a7fUndefined locale: \"\u00a78" + key + "\u00a7f\"");
            return;
        }
        if (message.length > 0 && message[0].equalsIgnoreCase("null")) {
            return;
        }
        for (String line : message) {
            sender.sendMessage(line);
        }
    }

    public static String materialToString(Block block) {
        if (block instanceof EntityBlock) {
            String name = ((EntityBlock)block).getEntity().getType().name();
            return StringUtil.capitalizeFirstLetter(StringUtil.fastReplace(name, '_', ' '));
        }
        return LWC.materialToString(block.getType());
    }

    public int fastRemoveProtectionsByPlayer(CommandSender sender, String player, boolean shouldRemoveBlocks) {
        UUID uuid = UUIDRegistry.getUUID(player);
        int ret = this.fastRemoveProtections(sender, "Lower(owner) = Lower('" + (uuid != null ? uuid.toString() : player) + "')", shouldRemoveBlocks);
        this.physicalDatabase.invalidateHistory(uuid != null ? uuid.toString() : player);
        return ret;
    }

    public int transferProtectionsOfPlayer(CommandSender sender, String oldplayer, UUID newplayerid) {
        String newplayeridstring = newplayerid.toString();
        UUID uuid = UUIDRegistry.getUUID(oldplayer);
        String oldPlayerString = uuid != null ? uuid.toString() : oldplayer;
        List<Protection> protections = this.physicalDatabase.loadProtectionsByPlayerAlsoIfNotOwner(oldplayer);
        for (Protection p : protections) {
            if (p.getOwner() != null && p.getOwner().equalsIgnoreCase(oldPlayerString)) {
                p.setOwner(newplayerid);
            }
            for (Permission perm : p.getPermissions()) {
                if (perm.getType() != Permission.Type.PLAYER || perm.getName() == null || !perm.getName().equalsIgnoreCase(oldPlayerString)) continue;
                perm.setName(newplayeridstring);
                p.setModified();
            }
            p.save();
            this.protectionCache.addProtection(p);
        }
        return protections.size();
    }

    public int fastRemoveProtections(CommandSender sender, String where, boolean shouldRemoveBlocks) {
        ArrayList<Block> removeBlocks = null;
        if (shouldRemoveBlocks) {
            removeBlocks = new ArrayList<Block>();
        }
        if (where != null && !((String)where).trim().isEmpty()) {
            where = " WHERE " + ((String)where).trim();
        }
        sender.sendMessage("Loading protections via STREAM mode");
        List<Protection> protections = this.physicalDatabase.streamDeleteProtections((String)where, sender);
        for (Protection protection : protections) {
            Protection cached;
            if (shouldRemoveBlocks) {
                removeBlocks.add(protection.getBlock());
            }
            if ((cached = this.protectionCache.getProtection(protection.getCacheKey())) == null) continue;
            cached.removeCache();
        }
        if (shouldRemoveBlocks) {
            this.removeBlocks(sender, removeBlocks);
        }
        return protections.size();
    }

    private void removeBlocks(CommandSender sender, List<Block> blocks) {
        int count = 0;
        for (Block block : blocks) {
            if (block == null || !this.isProtectable(block)) continue;
            Block doubleChest = BlockUtil.findAdjacentDoubleChest(block);
            if (doubleChest != null) {
                this.removeInventory(doubleChest);
                doubleChest.setType(Material.AIR);
            }
            this.removeInventory(block);
            block.setType(Material.AIR);
            ++count;
        }
        sender.sendMessage("Removed " + count + " blocks from the world");
    }

    private void removeInventory(Block block) {
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder holder = (InventoryHolder)block.getState();
        holder.getInventory().clear();
    }

    public boolean blockEquals(Block block, Block block2) {
        return block.getType() == block2.getType() && block.getX() == block2.getX() && block.getY() == block2.getY() && block.getZ() == block2.getZ();
    }

    public Protection findProtection(Entity entity) {
        int A = 50000 + entity.getUniqueId().hashCode();
        CacheKey cacheKey = ProtectionCache.cacheKey(entity.getWorld().getName(), A, A, A);
        if (this.protectionCache.isKnownNull(cacheKey)) {
            return null;
        }
        Protection protection = this.physicalDatabase.loadProtection(entity.getWorld().getName(), A, A, A);
        if (protection == null) {
            this.protectionCache.addKnownNull(cacheKey);
        }
        return protection != null && protection.isEntity() ? protection : null;
    }

    public Protection findProtection(Location location) {
        CacheKey cacheKey = ProtectionCache.cacheKey(location);
        if (this.protectionCache.isKnownNull(cacheKey)) {
            return null;
        }
        Protection protection = this.protectionCache.getProtection(cacheKey);
        return protection != null ? protection : this.findProtection(location.getBlock().getState());
    }

    public Protection findProtection(Block block) {
        return this.findProtection(block.getState());
    }

    public Protection findProtection(BlockState block) {
        if (block instanceof EntityBlock) {
            return this.findProtection(((EntityBlock)block).getEntity());
        }
        if (block.getType() == Material.AIR) {
            return this.physicalDatabase.loadProtection(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
        }
        ProtectionFinder finder = new ProtectionFinder(this);
        boolean result = finder.matchBlocks(block);
        Protection found = null;
        if (result) {
            found = finder.loadProtection();
        }
        if (found == null) {
            this.protectionCache.addKnownNull(ProtectionCache.cacheKey(block.getLocation()));
        }
        return found;
    }

    public boolean blockEquals(BlockState block, BlockState block2) {
        return block.getType() == block2.getType() && block.getX() == block2.getX() && block.getY() == block2.getY() && block.getZ() == block2.getZ();
    }

    public Protection findProtection(World world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        return this.findProtection(new Location(world, (double)x, (double)y, (double)z));
    }

    public boolean isProtectable(BlockState state) {
        Material material = state.getType();
        if (material == null) {
            return false;
        }
        return this.protectableBlocks.contains(state.getType());
    }

    public boolean isProtectable(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (this.protectableEntites.contains(entity.getType())) {
            return true;
        }
        return entity instanceof LivingEntity && !(entity instanceof Player) && !(entity instanceof ArmorStand) && !((LivingEntity)entity).hasAI() && Boolean.parseBoolean(this.resolveSpecialProtectionConfiguration("noaimob", "enabled"));
    }

    public String getAutoRegisterType(Entity entity) {
        String protection;
        if (entity instanceof LivingEntity && !(entity instanceof Player) && !(entity instanceof ArmorStand) && !((LivingEntity)entity).hasAI() && (protection = this.resolveSpecialProtectionConfiguration("noaimob", "autoRegister")) != null) {
            return protection;
        }
        return this.resolveProtectionConfiguration(entity.getType(), "autoRegister");
    }

    public String resolveProtectionConfiguration(EntityType state, String node) {
        if (state == null) {
            return this.configuration.getString("protections." + node);
        }
        String cacheKey = "e-" + state.name() + "-" + node;
        if (this.protectionConfigurationCache.containsKey(cacheKey)) {
            return this.protectionConfigurationCache.get(cacheKey);
        }
        String value = this.configuration.getString("protections." + node);
        String temp = this.configuration.getString("protections.entities." + state.name().toLowerCase() + "." + node);
        if (temp != null && !temp.isEmpty()) {
            value = temp;
        }
        this.protectionConfigurationCache.put(cacheKey, value);
        return value;
    }

    public String resolveSpecialProtectionConfiguration(String special, String node) {
        String cacheKey = "s-" + special + "-" + node;
        if (this.protectionConfigurationCache.containsKey(cacheKey)) {
            return this.protectionConfigurationCache.get(cacheKey);
        }
        String value = this.configuration.getString("protections.special." + special + "." + node);
        this.protectionConfigurationCache.put(cacheKey, value);
        return value;
    }

    public boolean hasAdminPermission(CommandSender sender, String node) {
        return this.isAdmin(sender) || this.hasPermission(sender, node, "lwc.admin");
    }

    public boolean isAdmin(CommandSender sender) {
        return !(sender instanceof Player) || this.isAdmin((Player)sender);
    }

    public boolean hasPermission(CommandSender sender, String node, String ... fallback) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        boolean hasNode = this.hasPermission(player, node);
        if (!hasNode) {
            for (String temp : fallback) {
                if (!this.hasPermission(player, temp)) continue;
                return true;
            }
        }
        return hasNode;
    }

    public boolean hasPlayerPermission(CommandSender sender, String node) {
        return this.hasPermission(sender, node, "lwc.protect");
    }

    public boolean isModeEnabled(String mode) {
        return this.configuration.getBoolean("modes." + mode + ".enabled", true);
    }

    public boolean isModeWhitelisted(Player player, String mode) {
        return this.hasPermission((CommandSender)player, "lwc.mode." + mode, "lwc.allmodes");
    }

    public boolean isProtectable(Block block) {
        Material material = block.getType();
        if (block instanceof EntityBlock) {
            return this.isProtectable(((EntityBlock)block).getEntity());
        }
        if (material == null) {
            return false;
        }
        return this.protectableBlocks.contains(block.getType());
    }

    public String resolveProtectionConfiguration(Block block, String node) {
        if (block == null) {
            return null;
        }
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            return this.resolveProtectionConfiguration(entityBlock.getEntity().getType(), node);
        }
        return this.resolveProtectionConfiguration(block.getType(), node);
    }

    public String resolveProtectionConfiguration(Material material, String node) {
        if (material == null) {
            return this.configuration.getString("protections." + node);
        }
        String cacheKey = "b-" + material.name() + "-" + node;
        if (this.protectionConfigurationCache.containsKey(cacheKey)) {
            return this.protectionConfigurationCache.get(cacheKey);
        }
        ArrayList<String> names = new ArrayList<String>();
        String materialName = LWC.normalizeMaterialName(material);
        names.add(materialName);
        if (!materialName.equals(material.toString().toLowerCase())) {
            names.add(material.toString().toLowerCase());
        }
        names.add("*");
        String value = this.configuration.getString("protections." + node);
        for (String name : names) {
            String temp = this.configuration.getString("protections.blocks." + name + "." + node);
            if (temp == null || temp.isEmpty()) continue;
            value = temp;
        }
        this.protectionConfigurationCache.put(cacheKey, value);
        return value;
    }

    public void load() {
        this.configuration = Configuration.load("core.yml");
        this.registerCoreModules();
        new ConfigPost300().run();
        this.plugin.loadDatabase();
        Statistics.init();
        this.physicalDatabase = new PhysDB();
        this.permissions = new SuperPermsPermissions();
        if (this.resolvePlugin("Vault") != null) {
            this.permissions = new VaultPermissions();
        }
        this.currency = new NoCurrency();
        if (this.resolvePlugin("Vault") != null) {
            this.currency = new VaultCurrency();
        }
        this.log("Connecting to " + String.valueOf((Object)Database.DefaultType));
        try {
            if (!this.physicalDatabase.connect()) {
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
                return;
            }
            this.physicalDatabase.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new MySQLPost200().run();
        this.preloadProtectables();
        BlockMap.instance().init();
        this.physicalDatabase.precache();
        this.moduleLoader.loadAll();
    }

    private void registerCoreModules() {
        this.registerModule(new LimitsV2());
        this.registerModule(new LimitsModule());
        this.registerModule(new CreateModule());
        this.registerModule(new ModifyModule());
        this.registerModule(new DestroyModule());
        this.registerModule(new FreeModule());
        this.registerModule(new InfoModule());
        this.registerModule(new UnlockModule());
        this.registerModule(new OwnersModule());
        this.registerModule(new DoorsModule());
        this.registerModule(new DebugModule());
        this.registerModule(new CreditsModule());
        this.registerModule(new HistoryModule());
        this.registerModule(new ConfirmModule());
        this.registerModule(new BaseAdminModule());
        this.registerModule(new AdminCache());
        this.registerModule(new AdminTransfer());
        this.registerModule(new AdminCleanup());
        this.registerModule(new AdminClear());
        this.registerModule(new AdminFind());
        this.registerModule(new AdminForceOwner());
        this.registerModule(new AdminLocale());
        this.registerModule(new AdminPurge());
        this.registerModule(new AdminReload());
        this.registerModule(new AdminRemove());
        this.registerModule(new AdminReport());
        this.registerModule(new AdminVersion());
        this.registerModule(new AdminPurgeBanned());
        this.registerModule(new AdminExpire());
        this.registerModule(new AdminDump());
        this.registerModule(new AdminRebuild());
        this.registerModule(new AdminView());
        this.registerModule(new BaseSetupModule());
        this.registerModule(new DatabaseSetupModule());
        this.registerModule(new LimitsSetup());
        this.registerModule(new BaseFlagModule());
        this.registerModule(new RedstoneModule());
        this.registerModule(new BaseModeModule());
        this.registerModule(new PersistModule());
        this.registerModule(new NoSpamModule());
        if (this.resolvePlugin("WorldGuard") != null) {
            this.registerModule(new WorldGuard());
        }
    }

    private void registerModule(Module module) {
        this.moduleLoader.registerModule((Plugin)this.plugin, module);
    }

    private Plugin resolvePlugin(String name) {
        Plugin temp = this.plugin.getServer().getPluginManager().getPlugin(name);
        if (temp == null) {
            return null;
        }
        return temp;
    }

    public void processRightsModifications(CommandSender sender, Protection protection, String ... arguments) {
        try {
            Protection.Type protectionType = Protection.Type.matchType(arguments[0]);
            if (protectionType != null) {
                protection.setType(protectionType);
                protection.save();
                if (protectionType == Protection.Type.PASSWORD) {
                    String password = StringUtil.join(arguments, 1);
                    protection.setPassword(this.encrypt(password));
                }
                this.sendLocale(sender, "protection.typechanged", "type", this.plugin.getMessageParser().parseMessage(protectionType.toString().toLowerCase(), new Object[0]));
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (String value : arguments) {
            UUID uuid;
            boolean remove = false;
            boolean isAdmin = false;
            Permission.Type type = Permission.Type.PLAYER;
            if (value.startsWith("id:")) continue;
            if (value.startsWith("-")) {
                remove = true;
                value = value.substring(1);
            }
            if (value.startsWith("@")) {
                isAdmin = true;
                value = value.substring(1);
            }
            if (value.toLowerCase().startsWith("p:")) {
                type = Permission.Type.PLAYER;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("g:")) {
                type = Permission.Type.GROUP;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("t:")) {
                type = Permission.Type.TOWN;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("town:")) {
                type = Permission.Type.TOWN;
                value = value.substring(5);
            }
            if (value.toLowerCase().startsWith("item:")) {
                type = Permission.Type.ITEM;
                value = value.substring(5);
            }
            if (value.toLowerCase().startsWith("r:")) {
                type = Permission.Type.REGION;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("region:")) {
                type = Permission.Type.REGION;
                value = value.substring(7);
            }
            if (value.trim().isEmpty()) continue;
            String localeChild = type.toString().toLowerCase();
            if (type == Permission.Type.PLAYER && (uuid = UUIDRegistry.getUUID(value)) != null) {
                value = uuid.toString();
            }
            if (!remove) {
                Permission permission = new Permission(value, type);
                permission.setAccess(isAdmin ? Permission.Access.ADMIN : Permission.Access.PLAYER);
                protection.addPermission(permission);
                protection.save();
                if (type == Permission.Type.PLAYER) {
                    this.sendLocale(sender, "protection.interact.rights.register." + localeChild, "name", UUIDRegistry.getNameOrUUID(value), "isadmin", isAdmin ? " [\u00a74ADMIN\u00a76]" : "");
                    continue;
                }
                this.sendLocale(sender, "protection.interact.rights.register." + localeChild, "name", value, "isadmin", isAdmin ? " [\u00a74ADMIN\u00a76]" : "");
                continue;
            }
            protection.removePermissions(value, type);
            protection.save();
            if (type == Permission.Type.PLAYER) {
                this.sendLocale(sender, "protection.interact.rights.remove." + localeChild, "name", UUIDRegistry.getNameOrUUID(value), "isadmin", isAdmin ? " [\u00a74ADMIN\u00a76]" : "");
                continue;
            }
            this.sendLocale(sender, "protection.interact.rights.remove." + localeChild, "name", value, "isadmin", isAdmin ? " [\u00a74ADMIN\u00a76]" : "");
        }
    }

    private void preloadProtectables() {
        this.protectableBlocks.clear();
        this.protectableEntites.clear();
        for (Material material : Material.values()) {
            if (!Boolean.parseBoolean(this.resolveProtectionConfiguration(material, "enabled"))) continue;
            this.protectableBlocks.add(material);
        }
        for (Material material : EntityType.values()) {
            if (!Boolean.parseBoolean(this.resolveProtectionConfiguration((EntityType)material, "enabled"))) continue;
            this.protectableEntites.add((EntityType)material);
        }
    }

    public void reload() {
        this.plugin.loadLocales();
        this.protectionConfigurationCache.clear();
        Configuration.reload();
        this.preloadProtectables();
        this.moduleLoader.dispatchEvent(new LWCReloadEvent());
    }

    public void reloadDatabase() {
        try {
            this.physicalDatabase = new PhysDB();
            this.physicalDatabase.connect();
            this.physicalDatabase.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeModes(CommandSender sender) {
        if (sender instanceof Player) {
            Player bPlayer = (Player)sender;
            if (this.notInPersistentMode(bPlayer.getName())) {
                this.wrapPlayer((CommandSender)bPlayer).removeAllActions();
            }
        } else if (sender instanceof LWCPlayer) {
            this.removeModes((CommandSender)((LWCPlayer)sender).getBukkitPlayer());
        }
    }

    public boolean notInPersistentMode(String player) {
        return !this.wrapPlayer((CommandSender)Bukkit.getServer().getPlayer(player)).hasMode("persist");
    }

    public void sendFullHelp(CommandSender sender) {
        this.sendLocale(sender, "help.basic", new Object[0]);
        if (this.isAdmin(sender)) {
            sender.sendMessage("");
            sender.sendMessage("\u00a74/lwc admin - Administration");
        }
    }

    public void sendSimpleUsage(CommandSender player, String command) {
        this.sendLocale(player, "help.simpleusage", "command", command);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ICurrency getCurrency() {
        return this.currency;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public IPermissions getPermissions() {
        return this.permissions;
    }

    public PhysDB getPhysicalDatabase() {
        return this.physicalDatabase;
    }

    public LWCPlugin getPlugin() {
        return this.plugin;
    }

    public ProtectionCache getProtectionCache() {
        return this.protectionCache;
    }

    public double getVersion() {
        return Double.parseDouble(this.plugin.getDescription().getVersion());
    }

    public boolean isHistoryEnabled() {
        return !this.configuration.getBoolean("core.disableHistory", false);
    }
}

