/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.UUIDRegistry;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminForceOwner
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("forceowner")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        LWCPlayer player = lwc.wrapPlayer((CommandSender)event.getPlayer());
        Action action = player.getAction("forceowner");
        String newOwner = action.getData();
        protection.setOwner(newOwner);
        protection.save();
        lwc.sendLocale(player, "protection.interact.forceowner.finalize", "player", protection.getFormattedOwnerPlayerName());
        lwc.removeModes(player);
        event.setResult(Module.Result.CANCEL);
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("forceowner")) {
            return;
        }
        LWC lwc = event.getLWC();
        Player player = event.getPlayer();
        lwc.sendLocale((CommandSender)player, "protection.interact.error.notregistered", "block", LWC.materialToString(event.getBlock()));
        lwc.removeModes((CommandSender)player);
        event.setResult(Module.Result.CANCEL);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("forceowner")) {
            return;
        }
        event.setCancelled(true);
        if (args.length < 2) {
            lwc.sendSimpleUsage(sender, "/lwc admin forceowner <Player> [ProtectionID]");
            return;
        }
        String newOwner = args[1];
        if (args.length > 2) {
            try {
                int protectionId = Integer.parseInt(args[2]);
                Protection protection = lwc.getPhysicalDatabase().loadProtection(protectionId);
                if (protection == null) {
                    lwc.sendLocale(sender, "lwc.protectionnotfound", new Object[0]);
                    return;
                }
                UUID uuid = UUIDRegistry.getUUID(newOwner);
                if (uuid != null) {
                    protection.setOwner(uuid);
                } else {
                    protection.setOwner(newOwner);
                }
                protection.save();
                lwc.sendLocale(sender, "protection.interact.forceowner.finalize", "player", UUIDRegistry.formatPlayerName(newOwner));
                return;
            }
            catch (NumberFormatException e) {
                lwc.sendLocale(sender, "lwc.invalidprotectionid", new Object[0]);
                return;
            }
        }
        if (!(sender instanceof Player)) {
            lwc.sendLocale(sender, "protection.admin.noconsole", new Object[0]);
            return;
        }
        LWCPlayer player = lwc.wrapPlayer(sender);
        Action action = new Action();
        action.setName("forceowner");
        action.setPlayer(player);
        UUID uuid = UUIDRegistry.getUUID(newOwner);
        if (uuid != null) {
            action.setData(uuid.toString());
        } else {
            action.setData(newOwner);
        }
        player.addAction(action);
        lwc.sendLocale(sender, "protection.admin.forceowner.finalize", "player", newOwner);
    }
}

